# FILE: LandMassesFeatures.py
# PURPOSE: A script for using LandMasses's feature generator.
# VERSION 1.0

# Import the required files.

import operator
from CvPythonExtensions import *
import CvUtil
import CvMapGeneratorUtil
from CvMapGeneratorUtil import FractalWorld
from CvMapGeneratorUtil import TerrainGenerator
from CvMapGeneratorUtil import FeatureGenerator
import pickle
import math

#--------------------------------------------------------------------------------------------------------------------------#
# Predefined variables.
#--------------------------------------------------------------------------------------------------------------------------#

cachedMenuChoices = []
isamodule = False

#--------------------------------------------------------------------------------------------------------------------------#
# Step 1: Distinguish between the different feature types.
#--------------------------------------------------------------------------------------------------------------------------#

def addFeatures(module = False):

        global isamodule

        if not module:
                isamodule = False
        elif module:
                isamodule = True

        cymap = CyMap()
	gc = CyGlobalContext()
	dice = gc.getGame().getMapRand()
	saveSettings()

	# Determine which options have been selected.

	if isamodule:
                settings = open('LandMasses Features.cfg', 'r')
                SavedSettings = pickle.load(settings)
                Settings = []
                for Option in range(len(selection_names_and_values)):
                        for Choice in range(len(selection_names_and_values[Option])):
                                if SavedSettings[Option][1] == selection_names_and_values[Option][Choice][0]:
                                        Settings.append(selection_names_and_values[Option][Choice][1])
                                        break
                [Jungle, Forest, FloodPlains] = Settings
        elif not isamodule:
                Jungle = getSelectedMapValue("Jungle:")
                Forest = getSelectedMapValue("Forest:")
                FloodPlains = getSelectedMapValue("Flood Plains:")

        # If 'Random' has been selected for any options.

        if Jungle == 1:
                Jungle = 60 + (dice.get(3, "Less, normal, or more jungle."))*20

        if Forest == 1:
                Forest = 45 + (dice.get(3, "Less, normal, or more forest."))*15

        FeatureGen = FeatureGenerator(Jungle, Forest, 5, 6, -1, -1)
        FeatureTypes = FeatureGen.addFeatures()

        # If the alternative flood plains generator has been selected.

        if FloodPlains == 2:

                cymap = CyMap()
                gc = CyGlobalContext()
                Width = gc.getMap().getGridWidth()
                Height = gc.getMap().getGridHeight()
                Area = Width*Height

                for I in range(Area):

                        Plot = cymap.plotByIndex(I)

                        if Plot.getPlotType() != PlotTypes.PLOT_LAND:
                                continue

                        Plot = cymap.plotByIndex(I)
                        Terrain = Plot.getTerrainType()
                        Features = Plot.getFeatureType()

                        if Features != -1:
                                continue

                        if not Plot.isRiverSide():
                                continue

                        if Terrain == 0 or Terrain == 1 or Terrain == 3:
                                if dice.get(3, "Place a flood plain?") == FloodPlains:
                                        Plot.setFeatureType(3, -1)

        return 0

#--------------------------------------------------------------------------------------------------------------------------#
# Step 2: Add additional menu options.
#--------------------------------------------------------------------------------------------------------------------------#

selection_titles = [unicode("Jungle:"),
                    unicode("Forest:"),
                    unicode("Flood Plains:"),
                    ]

selection_names_and_values = [
        [
                ["Less jungle", 100],
                ["Normal jungle", 80],
                ["More jungle", 60],
                ["Random", 1],
		],
        [
                ["Less forest", 75],
                ["Normal forest", 60],
                ["More forest", 45],
                ["Random", 1],
		],
        [
                ["Normal flood plains placement", 1],
                ["Extra flood plains", 2],
                ],
        ]

#--------------------------------------------------------------------------------------------------------------------------#
# Step 3: Further functions.
#--------------------------------------------------------------------------------------------------------------------------#

def isSeaLevelMap():
        return 0

def isRandomCustomMapOption(argsList):
        return False

def getDescription():
	return unicode("LandMasses Map Size")

def getNumCustomMapOptions():
	return len(selection_titles)

def getCustomMapOptionName(argsList):
	return selection_titles[argsList[0]]

def getSelectedMapValue(OptionName):
        
	gc = CyGlobalContext()
	cymap = CyMap()
	dice = gc.getGame().getMapRand()
	
	for Option in range(len(selection_titles)):
		if selection_titles[Option] == OptionName:
                        break
	
	Choice = int(cymap.getCustomMapOption(Option))
	
	if Choice >= len(selection_names_and_values[Option]):
		Choice = 0
				
	cachedMenuChoices[Option] = Choice
	
	return selection_names_and_values[Option][Choice][1]

def getNumCustomMapOptionValues(argsList):
        return len(selection_names_and_values[argsList[0]])

def getCustomMapOptionDescAt(argsList):
	return unicode(selection_names_and_values[argsList[0]][argsList[1]][0])

# Save selected map options.

def saveSettings():

        global isamodule

        if isamodule == True:
                return
    
	cymap = CyMap()
	settings = open('LandMasses Features.cfg', 'w')
	SavedSettings = []
	for Option in range(len(selection_titles)):
		Choice = int(cymap.getCustomMapOption(Option))
		ChoiceName = selection_names_and_values[Option][Choice][0]
		SavedSettings.append((selection_titles[Option], ChoiceName))
		
	print SavedSettings
	try:
		pickle.dump(SavedSettings, settings)
	except Exception, inst:
		print "    Pickling Error trying to save smartmap settings to LandMasses Features.cfg", inst
	settings.close()

# Find previously selected map options.

def getCustomMapOptionDefault(argsList):
	result = 0
	try:
		settings = open('LandMasses Features.cfg', 'r')
		SavedSettings = pickle.load(settings)
		for EachOption in range(len(SavedSettings)):
			Option, ChoiceName = SavedSettings[argsList[0]]
			if Option == selection_titles[argsList[0]]:
				for EachChoice in range(len(selection_names_and_values[argsList[0]])):
					EachChoiceName, EachChoiceValue = selection_names_and_values[argsList[0]][EachChoice]
					if EachChoiceName == ChoiceName:
						result = EachChoice
		settings.close()
	except IOError:
		print "    Couldn't find LandMasses Features.cfg"
	except EOFError:
		print "    Bad contents in LandMasses Features.cfg"
		
	return result

def isAdvancedMap():
	return 1

def beforeInit():
	global cachedMenuChoices
	cachedMenuChoices = []
	for Choice in range(len(selection_names_and_values)):
		cachedMenuChoices.append((0))
		
def beforeGeneration():
	global cachedMenuChoices
	for Choice in range(len(selection_names_and_values)):
		if selection_names_and_values[Choice][0] != "Wrap:":
			cachedMenuChoices[Choice] = 0

#--------------------------------------------------------------------------------------------------------------------------#
# Build Notes.
#--------------------------------------------------------------------------------------------------------------------------#

# Version 1.0:
# Seems to work as intended.
